#include "blue-dream.h"

t_dword get_ecco2_world_property(int id, int type)
{
	int result = 0;

	t_dword table[] = {

		// PALETTE

		0x10afda, // HOMEBAY
		0x135a96, // TRELLIASBAY
		0x155936, // AQUATUBEWAY
		0xecc1e,  // SEAOFGREEN
		0x19396e, // LUNARBAY
		0x180b4e, // VORTEXFUTURE
		0x1653ca, // ATLANTIS

		0x106c0e, // GLOBEHOLDER
		0x15f74e, // ASTERITESHOME
		0x1b3f1a, // VORTEXQUEEN
		0x1d7a92, // BIGWATER
		0x1dbfbe, // TMACHINE
		0x1bd84a, // PROLOGUE
		0x1ca02e, // MESSAGE

		// METATILED_OFFSET

		0x118326, // HOMEBAY
		0x13b338, // TRELLIASBAY
		0x157fac, // AQUATUBEWAY
		0xf5160,  // SEAOFGREEN
		0x19cb00, // LUNARBAY
		0x187332, // VORTEXFUTURE
		0x16bcea, // ATLANTIS

		0x10701a, // GLOBEHOLDER
		0,        // ASTERITESHOME
		0x1b42f0, // VORTEXQUEEN
		0x1d83ac, // BIGWATER
		0x1dd056, // TMACHINE
		0x1bda5e, // PROLOGUE
		0, // MESSAGE

		// METATILEC_OFFSET

		0x12a6b4, // HOMEBAY
		0x148b3a, // TRELLIASBAY
		0x158cda, // AQUATUBEWAY
		0xfb726,  // SEAOFGREEN
		0x1a63ee, // LUNARBAY
		0x1890b2, // VORTEXFUTURE
		0x173e02, // ATLANTIS

		0x1073e8, // GLOBEHOLDER
		0x16100e, // ASTERITESHOME
		0x1b597e, // VORTEXQUEEN
		0x1d8f06, // BIGWATER
		0,        // TMACHINE
		0,        // PROLOGUE
		0,        // MESSAGE

		// PALETTE_TOTAL

		0x880,    // HOMEBAY
		0x800,	  // TRELLIASBAY
		0x500,    // AQUATUBEWAY
		0,		  // SEAOFGREEN
		0,        // LUNARBAY
		0xc80,    // VORTEXFUTURE
		0x1000,   // ATLANTIS

		0x288,	  // GLOBEHOLDER
		0x80,     // ASTERITESHOME
		0x160,    // VORTEXQUEEN
		0x80,     // BIGWATER
		0x80,     // TMACHINE
		0,        // PROLOGUE
		0,        // MESSAGE

		// METATILED_TOTAL

		0x3d0,    // HOMEBAY
		0x224,    // TRELLIASBAY
		0x38,     // AQUATUBEWAY
		0x11c,    // SEAOFGREEN
		0x18d,    // LUNARBAY
		0x8c,     // VORTEXFUTURE
		0x15c,    // ATLANTIS

		0x1c,     // GLOBE HOLDER
		0,        // ASTERITESHOME
		0x88,     // VORTEXQUEEN
		0x30,     // BIGWATER
		0x38,     // TMACHINE
		0x90,     // PROLOGUE
		0,        // MESSAGE

		// METATILEC_TOTAL

		0x28c,    // HOMEBAY
		0x2f4,    // TRELLIASBAY
		0x40,     // AQUATUBEWAY
		0x400,    // SEAOFGREEN
		0x400,    // LUNARBAY
		0x400,    // VORTEXFUTURE
		0x400,    // ATLANTIS

		0x70,     // GLOBEHOLDER
		0x14,     // ASTERITESHOME
		0xbc,     // VORTEXQUEEN
		0x18,     // BIGWATER
		0,        // TMACHINE
		0,         // PROLOGUE
		0          // MESSAGE
	};

	result = table[id + type];

	if ((type == E2_METATILED_TOTAL) ||
		(type == E2_METATILEC_TOTAL))
		result >>= 2;

	return result;
}

t_dword get_ecco2_stage_property(int id, int type)
{
	int result = 0;

	t_dword table[] = {

		/* E2_WORLD */

		E2_WORLD_SEAOFGREEN,   // SEAOFGREEN
		E2_WORLD_SEAOFGREEN,   // DEEPRIDGE
		E2_WORLD_SEAOFGREEN,   // THEEYE
		E2_WORLD_SEAOFGREEN,   // SEAOFBIRDS
		E2_WORLD_SEAOFGREEN,   // SECRETCAVE
		E2_WORLD_SEAOFGREEN,   // THEHUNGRYONES
		E2_WORLD_SEAOFGREEN,   // CONVERGENCE
		E2_WORLD_GLOBEHOLDER, // GLOBEHOLDER
		E2_WORLD_HOMEBAY,      // SELECTIONSCR
		E2_WORLD_HOMEBAY,      // TWOTIDES
		E2_WORLD_HOMEBAY,      // THELOSTORCAS
		E2_WORLD_HOMEBAY,      // VENTSOFMEDUSA
		E2_WORLD_HOMEBAY,      // FOURISLANDS
		E2_WORLD_HOMEBAY,      // MAZEOFSTONE
		E2_WORLD_HOMEBAY,      // HOMEBAY
		E2_WORLD_HOMEBAY,      // SEAOFDARKNESS
		E2_WORLD_HOMEBAY,      // CRYSTALSPRINGS
		E2_WORLD_HOMEBAY,      // FAULTZONE
		E2_WORLD_HOMEBAY,      // GATEWAY
		E2_WORLD_TRELLIASBAY,  // TRELLIASBAY
		E2_WORLD_TRELLIASBAY,  // SKYWAY
		E2_WORLD_TRELLIASBAY,  // ASTERITESCAVE
		E2_WORLD_TRELLIASBAY,  // EAGLESBAY
		E2_WORLD_TRELLIASBAY,  // FINTOFEATHER
		E2_WORLD_TRELLIASBAY,  // SKYLANDS
		E2_WORLD_AQUATUBEWAY,  // TUBEOFMEDUSA
		E2_WORLD_AQUATUBEWAY,  // VORTEXARRIVED
		E2_WORLD_AQUATUBEWAY,  // AQUATUBEWAY
		E2_WORLD_AQUATUBEWAY,  // SKYTIDES
		E2_WORLD_ASTERITESHOME, // MORAYABYSS
		E2_WORLD_ASTERITESHOME, // ASTERITESHOME
		E2_WORLD_ASTERITESHOME, // EPILOGUE
		E2_WORLD_ATLANTIS,     // ATLANTIS
		E2_WORLD_ATLANTIS,     // FISHCITY
		E2_WORLD_ATLANTIS,     // CITYOFFOREVER
		E2_WORLD_VORTEXFUTURE, // BLACKCLOUDS
		E2_WORLD_VORTEXFUTURE, // VORTEXFUTURE
		E2_WORLD_VORTEXFUTURE, // GRAVITORBOX
		E2_WORLD_LUNARBAY,     // LUNARBAY
		E2_WORLD_LUNARBAY,     // DARKSEA
		E2_WORLD_LUNARBAY,     // NEWMACHINE
		E2_WORLD_LUNARBAY,     // INSIDE
		E2_WORLD_LUNARBAY,     // INTER
		E2_WORLD_LUNARBAY,     // INNUENDO
		E2_WORLD_LUNARBAY,     // TRANS
		E2_WORLD_VORTEXQUEEN,  // VORTEXQUEEN
		E2_WORLD_BIGWATER,     // BIGWATER
		E2_WORLD_BIGWATER,     // THEPOD
		E2_WORLD_TMACHINE,     // TMACHINE
		E2_WORLD_PROLOGUE,     // PROLOGUE

		/* E2_PALETTE_ROW_OFFSET */

		0xed8ea,  // SEAOFGREEN
		0xee8f2,  // DEEPRIDGE
		0xf02cc,  // THEEYE
		0xf22c6,  // SEAOFBIRDS
		0xf29aa,  // SECRETCAVE
		0xf2fcc,  // THEHUNGRYONES
		0xf4ba2,  // CONVERGENCE
		0x106efc, // GLOBEHOLDER
		0x10bafe, // SELECTIONSCR
		0x10bd14, // TWOTIDES
		0x10cefa, // THELOSTORCAS
		0x10f850, // VENTSOFMEDUSA
		0x110c32, // FOURISLANDS
		0x112f3a, // MAZEOFSTINE
		0x1152b2, // HOMEBAY
		0x115e10 + 0x2, // SEAOFDARKNESS 2 Added for light.
		0x116b76, // CRYSTALSPRINGS
		0x117388, // FAULTZONE
		0x117d72, // GATEWAY
		0x13643c, // TRELLIASBAY
		0x137aa8, // SKYWAY
		0x138798, // ASTERITESCAVE
		0x1394b0, // EAGLESBAY
		0x13a1f6, // FINTOFEATHER
		0x13aa4e, // SKYLANDS
		0x156136, // TUBEOFMEDUSA
		0x156748, // VORTEXARRIVED
		0x1567ac, // AQUATUBEWAY
		0x156d20, // SKYTIDES
		0x1609e6, // MORAYABYSS
		0x160ca2, // ASTERITESHOME
		0x160e56, // EPILOGUE
		0x16653a, // ATLANTIS
		0x168650, // FISHCITY
		0x1696b8, // CITYOFFOREVER
		0x181cca, // BLACKCLOUDS
		0x183df4, // VORTEXFUTURE
		0x1864ee, // GRAVITORBOX
		0x195b8a, // LUNARBAY
		0x19703c, // DARKSEA
		0x199da8, // NEWMACHINE
		0x19af9c, // INSIDE
		0x19b710, // INTER
		0x19bddc, // INNUENDO
		0x19c488, // TRANS
		0x1b41e8, // VORTEXQUEEN
		0x1d7c72, // BIGWATER
		0x1d810a, // THEPOD
		0x1dcfa6, // TMACHINE
		0x10cefa, // PROLOGUE

		/* E2_ATTRIBUTE_TABLE_OFFSET */

		0xed7d2,  // SEAOFGREEN
		0xed7fa,  // DEEPRIDGE
		0xed822,  // THEEYE
		0xed84a,  // SEAOFBIRDS
		0xed872,  // SECRETCAVE
		0xed89a,  // THEHUNGRYONES
		0xed8c2,  // CONVERGENCE
		0x106ed4, // GLOBEHOLDER
		0x10b946, // SELECTIONSCR
		0x10b96e, // TWOTIDES
		0x10b996, // THELOSTORCAS
		0x10b9be, // VENTSOFMEDUSA
		0x10b9e6, // FOURISLANDS
		0x10ba0e, // MAZEOFSTONE
		0x10ba36, // HOMEBAY
		0x10ba5e, // SEAOFDARKNESS
		0x10ba86, // CRYSTALSPRINGS
		0x10baae, // FAULTZONE
		0x10bad6, // GATEWAY
		0x13634c, // TRELLIASBAY
		0x136374, // SKYWAY
		0x13639c, // ASTERITESCAVE
		0x1363c4, // EAGLESBAY
		0x1363ec, // FINTOFEATHER
		0x136414, // SKYLANDS
		0x156096, // TUBEOFMEDUSA
		0x1560be, // VORTEXARRIVED
		0x1560e6, // AQUATUBEWAY
		0x15610e, // SKYTIDES
		0x16096e, // MORAYABYSS
		0x160996, // ASTERITESHOME
		0x1609be, // EPILOGUE
		0x1664c2, // ATLANTIS
		0x1664ea, // FISHCITY
		0x166512, // CITYOFFOREVER
		0x181c52, // BLACKCLOUDS
		0x181c7a, // VORTEXFUTURE
		0x181ca2, // GRAVITORBOX
		0x195a72, // LUNARBAY
		0x195a9a, // DARKSEA
		0x195ac2, // NEWMACHINE
		0x195aea, // INSIDE
		0x195b12, // INTER
		0x195b3a, // INNUENDO
		0x195b62, // TRANS
		0x1b41c0, // VORTEXQUEEN
		0x1d7c22, // BIGWATER
		0x1d7c4a, // THEPOD
		0x1dcf7e, // TMACHINE
		0x1bd9c8  // PROLOGUE
	};

	result = table[id + type];

	if (type == E2_PALETTEROW_OFFSET)
		result += 0x11;

	return result;
}

t_unicode *get_ecco2_stage_save_state(int id)
{
	const char *table[] = {
		"SEAOFGREEN.gsx",
		"DEEPRIDGE.gsx",
		"THEEYE.gsx",
		"SEAOFBIRDS.gsx",
		"SECRETCAVE.gsx",
		"THEHUNGRYONES.gsx",
		"CONVERGENCE.gsx",
		"GLOBEHOLDER.gsx",
		"SELECTIONSCR.gsx",
		"TWOTIDES.gsx",
		"THELOSTORCAS.gsx",
		"VENTSOFMEDUSA.gsx",
		"FOURISLANDS.gsx",
		"MAZEOFSTONE.gsx",
		"HOMEBAY.gsx",
		"SEAOFDARKNESS.gsx",
		"CRYSTALSPRINGS.gsx",
		"FAULTZONE.gsx",
		"GATEWAY.gsx",
		"TRELLIASBAY.gsx",
		"SKYWAY.gsx",
		"ASTERITESCAVE.gsx",
		"EAGLESBAY.gsx",
		"FINTOFEATHER.gsx",
		"SKYLANDS.gsx",
		"TUBEOFMEDUSA.gsx",
		"VORTEXARRIVED.gsx",
		"AQUATUBEWAY.gsx",
		"SKYTIDES.gsx",
		"MORAYABYSS.gsx",
		"ASTERITESHOME.gsx",
		"EPILOGUE.gsx",
		"ATLANTIS.gsx",
		"FISHCITY.gsx",
		"CITYOFFOREVER.gsx",
		"BLACKCLOUDS.gsx",
		"VORTEXFUTURE.gsx",
		"GRAVITORBOX.gsx",
		"LUNARBAY.gsx",
		"DARKSEA.gsx",
		"NEWMACHINE.gsx",
		"INSIDE.gsx",
		"INTER.gsx",
		"INNUENDO.gsx",
		"TRANS.gsx",
		"VORTEXQUEEN.gsx",
		"BIGWATER.gsx",
		"THEPOD.gsx",
		"TMACHINE_.gsx",
		"PROLOGUE.gsx"
	};

	return copy_append_string(
		"data/ECCO_2_US_JUNE_1994/", table[id]);
}