﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

/*
 * (pallete, palleteRAW, (int)TotalPalletes[ThisLevelGroup],
 *              Levelname, FGwidth, FGheight, BGwidth, BGheight, A[ThisLevelGroup][ThisLevelIndex].ROM_Xstart,
 *              A[ThisLevelGroup][ThisLevelIndex].ROM_Ystart, A[ThisLevelGroup][ThisLevelIndex].ROM_Xviewable,
 *              A[ThisLevelGroup][ThisLevelIndex].ROM_Yviewable
 *              );
 */

namespace E2ED
{
    public partial class LevelProperties : Form
    {
        int i;                              //Cyclic indexer
        int LastClickedPalleteIndex;
        PictureBox []pictureBox;
        Color []PalletePTR;
        short []PalleteRAWPTR;
        public LevelProperties(Color []PalleteVector, short []PalleteVectorRAW, int TotalPalletes,
                       int FGw, int FGh, int BGw, int BGh, int Xst, int Yst, int Xv, int Yv, Form1.Level level)
        {
            InitializeComponent();


            pictureBox = new PictureBox[64];
            PalletePTR = PalleteVector;
            PalleteRAWPTR = PalleteVectorRAW;
            PALSELUpDown1.Maximum = TotalPalletes - 1;
            PALSELUpDown2.Maximum = TotalPalletes - 1;
            PALSELUpDown3.Maximum = TotalPalletes - 1;
            PALSELUpDown4.Maximum = TotalPalletes - 1;
            PalID.Maximum = TotalPalletes - 1;

            for (i = 0; i < 64; i++)
            {
                // Initialize each color viewer of the pallete 
                pictureBox[i] = new System.Windows.Forms.PictureBox();

                pictureBox[i].BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
                pictureBox[i].Name = "Color" + i.ToString();
                pictureBox[i].Parent = groupBox1;
                pictureBox[i].Size = new System.Drawing.Size(8, 8);
                pictureBox[i].Location = new System.Drawing.Point(12 * (i % 16) + 24, 20 + (i / 16) * 16);
                pictureBox[i].BackColor = PalleteVector[i + (LastClickedPalleteIndex * 64)];
                toolTip1.SetToolTip(pictureBox[i], "0x" + (PalleteVectorRAW[i + (LastClickedPalleteIndex * 64)]).ToString("X").PadLeft(4, '0'));
            }

            //initialise values
            textBox1.Text = level.Levelname;
            FGx.Value = FGw;
            FGy.Value = FGh;
            BGx.Value = BGw;
            BGy.Value = BGh;
            VisibleX.Value = Xv;
            VisibleY.Value = Yv;
            EccoX.Value = Xst;
            EccoY.Value = Yst;
            WaterLevel.Value = level.WaterLevel;
            MusicID.Value = level.MusicID;
            Moon_checkBox.Checked = level.moon;
            Ypal0.Value = level.Y0;
            Ypal1.Value = level.Y1;
            Ypal2.Value = level.Y2;
            Ypal3.Value = level.Y3;
            PALSELUpDown1.Value = level.P0;
            PALSELUpDown2.Value = level.P1;
            PALSELUpDown3.Value = level.P2;
            PALSELUpDown4.Value = level.P3;
        }

        private void PALSELUpDown1_ValueChanged(object sender, EventArgs e)
        {
        }

        private void PALSELUpDown2_ValueChanged(object sender, EventArgs e)
        {
        }

        private void PALSELUpDown3_ValueChanged(object sender, EventArgs e)
        {
        }

        private void PALSELUpDown4_ValueChanged(object sender, EventArgs e)
        {
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void button2_Click_1(object sender, EventArgs e)
        {
            Close();
        }

        private void PalID_ValueChanged(object sender, EventArgs e)
        {
            LastClickedPalleteIndex = (int)PalID.Value;
            for (i = 0; i < 64; i++)
            {
                pictureBox[i].BackColor = PalletePTR[i + (LastClickedPalleteIndex * 64)];
                toolTip1.SetToolTip(pictureBox[i], "0x" + (PalleteRAWPTR[i + (LastClickedPalleteIndex * 64)]).ToString("X").PadLeft(4, '0'));
            }
        }
    }
}
